package com.tryjava.ext.xml;

import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.bind.JAXB;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * JAXB（Java Architecture for XML Binding）を使ってみる練習です。
 * <p>
 * ・JAXB（Java Architecture for XML Binding）<br/>
 * ・Java SE 6 以降で使えます。<br/>
 * </p>
 */
public class Jaxb01 {
	public void run() {
		marshal();
		unmarshal();
	}

	String marshal() {
		// 入力オブジェクト
		Person person = new Person();
		person.name = "山田 太郎";
		person.age = 20;

		// オブジェクト→XML変換
		StringWriter sw = new StringWriter();
		JAXB.marshal(person, sw);
		String xml = sw.toString();
		System.out.println(xml);

		return xml;
	}

	Person unmarshal() {
		// 入力XML
		String input = "" //
				+ "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n" //
				+ "<person>\n" //
				+ "    <name>山田 太郎</name>\n" //
				+ "    <age>20</age>\n" //
				+ "</person>\n" //
				;

		// XML→オブジェクト変換
		StringReader sr = new StringReader(input);
		Person person = JAXB.unmarshal(sr, Person.class);
		System.out.println(ToStringBuilder.reflectionToString(person));

		return person;
	}
}
