package com.tryjava.ext.xml;

import static org.hamcrest.CoreMatchers.*;
import static org.junit.Assert.*;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import javax.xml.bind.JAXBException;

import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;

import com.tryjava.ext.xml.Jaxb02Jp;
import com.tryjava.ext.xml.PersonJp;

@RunWith(Enclosed.class)
public class Jaxb02JpTest {

	public static class 日本語タグ {
		@Rule
		public TestName testName = new TestName();

		private Jaxb02Jp sut;

		@Before
		public void setUp() throws Exception {
			System.out.println("--- " + testName.getMethodName() + " ---");
			sut = new Jaxb02Jp();
		}

		/**
		 * タグ名に日本語を使うXMLを出力する練習です。
		 */
		@Test
		public void testMarshal() {
			// 実行
			String actual = sut.marshal();

			// 期待値
			String expected = "" //
					+ "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n" //
					+ "<人データ>\n" //
					+ "    <名前>山田 太郎</名前>\n" //
					+ "    <年齢>20</年齢>\n" //
					+ "</人データ>\n" //
					;

			// 検証
			assertThat(actual.toString(), is(expected));
		}

		/**
		 * タグ名に日本語を使うXMLを読み込む練習です。
		 */
		@Test
		public void testUnmarshal() {
			// 実行
			PersonJp actual = sut.unmarshal();

			// 検証
			assertThat(actual.name, is("山田 太郎"));
			assertThat(actual.age, is(20));
		}
	}

	public static class 日本語タグ_文字コード指定あり {
		@Rule
		public TestName testName = new TestName();

		private Jaxb02Jp sut;

		@Before
		public void setUp() throws Exception {
			System.out.println("--- " + testName.getMethodName() + " ---");
			sut = new Jaxb02Jp();
		}

		/**
		 * タグ名に日本語を使うXMLを出力する練習です。
		 * <p>
		 * ・ソースの文字コード：UTF-8<br/>
		 * ・XMLの文字コード：Shift_JIS<br/>
		 * </p>
		 */
		@Test
		public void testMarshalWithEncode() throws IOException, JAXBException {
			// 実行
			String actual = sut.marshalWithEncode();

			// 期待値
			URL url = getClass().getResource("/com/tryjava/text/xml/person_sjis.xml");
			File file = FileUtils.toFile(url);
			String expected = FileUtils.readFileToString(file, "Shift_JIS");

			// 検証
			assertThat(actual, is(expected));
		}

		/**
		 * タグ名に日本語を使うXMLを読み込む練習です。
		 * <p>
		 * ・ソースの文字コード：UTF-8<br/>
		 * ・XMLの文字コード：Shift_JIS<br/>
		 * </p>
		 */
		@Test
		public void testUnmarshalWithEncode() throws IOException {
			// 実行
			PersonJp actual = sut.unmarshalWithEncode();

			// 検証
			assertThat(actual.name, is("山田 太郎"));
			assertThat(actual.age, is(20));
		}
	}

}
