package com.tryjava.etc.junit.s18_2;

import static org.junit.Assert.*;
import static org.hamcrest.CoreMatchers.*;

import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(Enclosed.class)
public class CalculatorTest {

	@RunWith(Theories.class)
	public static class NormalTest {
		public static class Fixture {
			public int in1;
			public int in2;
			public int expected;

			public Fixture(int in1, int in2, int expected) {
				this.in1 = in1;
				this.in2 = in2;
				this.expected = expected;
			}
		}

		@DataPoints
		public static Fixture[] fixtures = { new Fixture(2, 1, 2),
				new Fixture(10, 2, 5), };

		@Theory
		public void testDivide(Fixture fixture) {
			// 準備
			Calculator sut = new Calculator();
			// 実行
			int actual = sut.divide(fixture.in1, fixture.in2);
			// 検証
			assertThat(actual, is(fixture.expected));
		}
	}

	@RunWith(JUnit4.class)
	public static class ExceptionTest {
		@Test(expected = IllegalArgumentException.class)
		public void testDivide() {
			Calculator sut = new Calculator();
			sut.divide(10, 0);
		}
	}

}
