package jp.co.tryjava.fizzbuzz;

/**
 * FizzBuzzクラス<br>
 * 与えられた数が3で割り切れる場合にはFizz、5で割り切れる場合にはBuzz、3でも5でも割り切れる場合にはFizzBuzzを返却します。
 */
public class FizzBuzz {
	private static final String FIZZ = "Fizz";
	private static final String BUZZ = "Buzz";

	public String getMessage(int max) {
		if (max <= 0) {
			throw new IllegalArgumentException("引数が不正です。max=" + max);
		}

		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < max; i++) {
			if (i != 0) {
				sb.append(",");
			}
			sb.append(getWord(i + 1));
		}

		return sb.toString();
	}

	private String getWord(int index) {
		String result = "";
		if (index % 3 == 0) {
			result += FIZZ;
		}
		if (index % 5 == 0) {
			result += BUZZ;
		}
		if (result.length() == 0) {
			result = String.valueOf(index);
		}
		return result;
	}
}
