package jp.co.tryjava.mail;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;

import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/**
 * メール送信サンプル<br>
 * 使用ライブラリ：JavaMail 1.4.5<br>
 * 参考<br>
 * 2007/09/04 日記: Java: JavaMail 調査 , JavaMailによるシンプルなメール送信サンプル<br>
 * http://www.igapyon.jp/igapyon/diary/2007/ig070904.html
 */
public class SampleMail {

	public static void main(String[] args) {
		new SampleMail().run();
	}

	public void run() {
		// SMTP設定
		// ポート：SSLなし（25）、SSLあり（465）
		Properties props = new Properties();
		props.setProperty("mail.smtp.host", "smtp.gmail.com");
		props.setProperty("mail.smtp.port", "465");
		props.setProperty("mail.smtp.connectiontimeout", "60000");
		props.setProperty("mail.smtp.timeout", "60000");
		props.setProperty("mail.smtp.auth", "true");
		// SSL関連設定
		props.setProperty("mail.smtp.socketFactory.class",
				"javax.net.ssl.SSLSocketFactory");
		props.setProperty("mail.smtp.socketFactory.fallback", "false");
		props.setProperty("mail.smtp.socketFactory.port", "465");

		final Session session = Session.getInstance(props, new Authenticator() {
			protected PasswordAuthentication getPasswordAuthentication() {
				// return new PasswordAuthentication("アカウント", "パスワード");
				return new PasswordAuthentication("gootarapapa@gmail.com",
						"googlepapa3");
			}
		});

		// デバッグを行います。標準出力にトレースが出ます。
		session.setDebug(true);

		// メッセージ内容の設定
		final MimeMessage message = new MimeMessage(session);
		try {
			// setFromでは、存在しないメールアドレスでも設定可能。
			// setTextを用いると 自動的に[text/plain]となる。
			message.setFrom(new InternetAddress("xxx@xxx.ne.jp", "送信者の表示名",
					"ISO-2022-JP"));
			message.addRecipient(Message.RecipientType.TO, new InternetAddress(
					"gootarapapa@gmail.com", "受信者の表示名", "ISO-2022-JP"));
			message.setSubject("メールタイトル", "ISO-2022-JP");
			message.setText("メール本文です。\n以上です。", "ISO-2022-JP");

			// 仮対策: 開始
			// setTextを呼び出した後に、ヘッダーを 7bitへと上書きします。
			// これは、一部のケータイメールが quoted-printable を処理できないことへの対策となります。
			message.setHeader("Content-Transfer-Encoding", "7bit");
			// 仮対策: 終了

			// その他の付加情報
			message.addHeader("X-Mailer", "JavaMail");
			message.setSentDate(new Date());
		} catch (MessagingException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}

		// メール送信
		try {
			Transport.send(message);
		} catch (AuthenticationFailedException e) {
			e.printStackTrace();
		} catch (MessagingException e) {
			e.printStackTrace();
		}

	}
}
