package jp.co.tryjava.fizzbuzz;

import static org.junit.Assert.*;
import static org.hamcrest.CoreMatchers.*;

import org.junit.Before;
import org.junit.Test;

public class ArgumentTest {

	private Argument sut;

	@Before
	public void setUp() {
		sut = new Argument();
	}

	/**
	 * 条件：引数なし<br>
	 * 期待結果：最大値がデフォルト値（50）であること。
	 */
	@Test
	public void testSet_Zero() {
		// 実行
		boolean actual = sut.set(new String[] {});
		// 検証
		assertThat(actual, is(true));
		assertThat(sut.getMax(), is(50));
	}

	/**
	 * 条件：正常値の引数あり<br>
	 * 期待結果：最大値に引数の値が設定されること。
	 */
	@Test
	public void testSet_Normal_001() {
		// 実行
		boolean actual = sut.set(new String[] { "49" });
		// 検証
		assertThat(actual, is(true));
		assertThat(sut.getMax(), is(49));
	}

	/**
	 * 条件：システム的に不正な引数（null）<br>
	 * 期待結果：例外が発生すること。
	 */
	@Test(expected = IllegalArgumentException.class)
	public void testSet_Exception_001() {
		sut.set(null);
	}

	/**
	 * 条件：ユーザ不正入力の引数（数字以外）<br>
	 * 期待結果：setメソッドが失敗を返却すること。エラーメッセージを取得できること。
	 */
	@Test
	public void testSet_Exception_002() {
		// 実行
		boolean actual = sut.set(new String[] { "xx" });
		// 検証
		assertThat(actual, is(false));
		assertThat(sut.getError(), is("引数が不正です。引数=xx"));
	}

	/**
	 * 条件：ユーザ不正入力の引数（0以下の数字）<br>
	 * 期待結果：setメソッドが失敗を返却すること。エラーメッセージを取得できること。
	 */
	@Test
	public void testSet_Exception_003() {
		// 実行
		boolean actual = sut.set(new String[] { "0" });
		// 検証
		assertThat(actual, is(false));
		assertThat(sut.getError(), is("引数が不正です。引数=0"));
	}

	/**
	 * 条件：ユーザ不正入力の引数（引数2個以上）<br>
	 * 期待結果：setメソッドが失敗を返却すること。エラーメッセージを取得できること。
	 */
	@Test
	public void testSet_Exception_004() {
		// 実行
		boolean actual = sut.set(new String[] { "1", "2" });
		// 検証
		assertThat(actual, is(false));
		assertThat(sut.getError(), is("引数の数が不正です。引数の数=2"));
	}

}
