package jp.co.tryjunit.s18_1;

public class StringUtils {

	public static String toSnakeCase(String string) {
		StringBuilder sb = new StringBuilder();

		for (int i = 0; i < string.length(); i++) {
			char c = string.charAt(i);

			// 1文字目が大文字でも、"_"が入らないように、小文字に変換する
			if (i == 0) {
				c = Character.toLowerCase(c);
			}

			// 大文字なら"_"を追加する
			if (isSeparator(c)) {
				sb.append('_');
			}

			sb.append(Character.toLowerCase(c));
		}

		return sb.toString();
	}

	private static boolean isSeparator(char c) {
		return !Character.isLowerCase(c);
	}

}
