package jp.co.tryjunit.s19_2;

import static jp.co.tryjunit.s19_2.EmployeeMatcher.*;
import static org.hamcrest.CoreMatchers.*;
import static org.junit.Assert.*;

import java.io.InputStream;
import java.util.List;

import org.junit.Test;

public class EmployeeTest {

	@Test
	public void testLoad() throws Exception {
		// 準備
		InputStream is = getClass().getResourceAsStream("Employee.txt");
		// テスト実行
		List<Employee> actual = Employee.load(is);
		// 検証
		Employee expected = new Employee();
		expected.firstName = "Ichiro";
		expected.lastName = "Tanaka";
		expected.email = "ichiro@example.com";
		assertThat(actual, is(notNullValue()));
		assertThat(actual.size(), is(1));
		Employee actualEmployee = actual.get(0);
		assertThat(actualEmployee, is(employee(expected)));
	}

}
