#import "BSDBBoardSource.h"

#import "BSDBViewer.h"

@implementation BSDBBoardSource
@synthesize excludeNotHasReadThread;

- (void)dealloc
{
	[boards release];
	
	[super dealloc];
}

- (void)setDelegate:(id)newDelegate
{
	if(delegate == newDelegate) return;
	
	if(![newDelegate respondsToSelector:@selector(beginUpdateBoardData:)]) {
		NSLog(@"(%@) delegate MUST response selector beginUpdateBoardData:",
			  NSStringFromClass([self class]));
		return;
	}
	if(![newDelegate respondsToSelector:@selector(finishUpdateBoardData:)]) {
		NSLog(@"(%@) delegate MUST response selector finishUpdateBoardData:",
			  NSStringFromClass([self class]));
		return;
	}
	
	delegate = newDelegate;	// not retain.
}
- (id)delegate
{
	return delegate;
}

- (void)setBoards:(NSArray *)array
{
	@synchronized(self) {
		[boards autorelease];
		boards = [array retain];
	}
}
- (NSArray *)boards
{
	id result = nil;
	@synchronized(self) {
		result = [boards retain];
	}
	return [result autorelease];
}

- (id)boardIDAtRow:(unsigned int)row
{
	id result = nil;
	@synchronized(self) {
		id dict = [boards objectAtIndex:row];
		result = [[dict objectForKey:@"boardid"] retain];
	}
	return [result autorelease];
}
- (NSArray *)boardIDsInSet:(NSIndexSet *)set
{
	NSMutableArray *result = [NSMutableArray array];
	@synchronized(self) {
		id rows = [boards objectsAtIndexes:set];
		NSEnumerator *enume = [rows objectEnumerator];
		id row;
		while(row = [enume nextObject]) {
			[result addObject:[row objectForKey:@"boardid"]];
		}
	}
	return result;
}
	

- (IBAction)update:(id)sender
{
	SQLiteDB *db = [BSDBViewer sqliteDB];
	
	if(!db) return;
	
	if([self delegate]) {
		[delegate beginUpdateBoardData:self];
	}
	
	NSString *query;
	if(excludeNotHasReadThread) {
		query = [NSString stringWithFormat:
				 @"SELECT boardname, boardid FROM %@ WHERE boardid != 0 "
				 @"AND boardid IN "
				 @"(SELECT DISTINCT boardid FROM %@)" 
				 ,
				 @"boardinfo",
				 @"ThreadInfo"];
	} else {
		query = [NSString stringWithFormat:
				 @"SELECT boardname, boardid FROM %@ WHERE boardid != 0",
				 @"boardinfo"];
	}
	
	
	id cursor = [db cursorForSQL:query];
	if([db lastErrorID] != 0) {
		NSLog(@"Fail Sending Query: %@", query);
		NSLog(@"SQLite Error: %@", [db lastError]);
		return;
	}
	
	[self setBoards:[cursor arrayForTableView]];
	
	if([self delegate]) {
		[delegate finishUpdateBoardData:self];
	}
}

@end
