#import "BSDBThreadSource.h"

#import "BSDBViewer.h"

@implementation BSDBThreadSource

@synthesize threads;
@synthesize boardID;


- (void)dealloc
{
	[threads release];
	[boardID release];
	
	[super dealloc];
}

- (void)setDelegate:(id)newDelegate
{
	if(delegate == newDelegate) return;
	
	if(![newDelegate respondsToSelector:@selector(beginUpdateThreadData:)]) {
		NSLog(@"(%@) delegate MUST response selector beginUpdateThreadData:",
			  NSStringFromClass([self class]));
		return;
	}
	if(![newDelegate respondsToSelector:@selector(finishUpdateThreadData:)]) {
		NSLog(@"(%@) delegate MUST response selector finishUpdateThreadData:",
			  NSStringFromClass([self class]));
		return;
	}
	
	delegate = newDelegate;	// not retain.
}
- (id)delegate
{
	return delegate;
}

- (void)setBoardID:(NSNumber *)newBoardID
{
	if([boardID isEqual:newBoardID]) return;
	
	[boardID autorelease];
	boardID = [newBoardID retain];
	
	[self update:self];
}
- (NSNumber *)boardID
{
	return boardID;
}

- (id)threadIDAtRow:(unsigned int)row
{
	return [self.threads objectAtIndex:row];
}
- (NSArray *)threadIDsInSet:(NSIndexSet *)set
{
	return [self.threads objectsAtIndexes:set];
}

/*
 CREATE TABLE ThreadInfo (boardID INTEGER NOT NULL,
 threadID INTEGER NOT NULL,
 threadName TEXT NOT NULL,
 numberOfAll NUMERIC,
 numberOfRead NUMERIC,
 modifiedDate NUMERIC,
 lastWrittenDate NUMERIC,
 threadStatus NUMERIC,
 threadAboneType NUMERIC,
 threadLabel NUMERIC, 
 isDatOchi INTEGER NOT NULL DEFAULT 0 CHECK(isDatOchi IN (0,1)),
 IsFavorite INTEGER NOT NULL DEFAULT 0 CHECK(IsFavorite IN (0,1)))
*/ 
/*
 SELECT * , 
	(SELECT count(*) FROM Favorites
		WHERE BoardID = BoardThreadInfoView.BoardID
		AND ThreadID = BoardThreadInfoView.ThreadID) AS isFavorite
	FROM BoardThreadInfoView;
 */
- (IBAction)update:(id)sender
{
	if(!boardID) return;
	
	SQLiteDB *db = [BSDBViewer sqliteDB];
	
	if(!db) return;
	
	if([self delegate]) {
		[delegate beginUpdateThreadData:self];
	}
	
	NSString *query = [NSString stringWithFormat:
					   @"SELECT threadname, threadid, numberOfAll, numberOfRead,"
					   @"modifiedDate, lastWrittenDate,"
					   @"isDatOchi"
					   @", (SELECT count(*) FROM Favorites "
					   @" WHERE BoardID = BoardThreadInfoView.BoardID "
					   @" AND ThreadID = BoardThreadInfoView.ThreadID) AS isFavorite "
					   @" FROM %@ WHERE boardid = %@ ",
					   @"BoardThreadInfoView",[self boardID]];
	
	id cursor = [db cursorForSQL:query];
	if([db lastErrorID] != 0) {
		NSLog(@"Fail Sending Query: %@", query);
		NSLog(@"SQLite Error: %@", [db lastError]);
		return;
	}
	
	[self setThreads:[cursor arrayForTableView]];
	
	if([self delegate]) {
		[delegate finishUpdateThreadData:self];
	}
}

@end
