#import <Cocoa/Cocoa.h>

#import "SQLiteDB.h"

@interface BSDBViewer : NSObject
{
	IBOutlet id window;
	IBOutlet id boardArrayController;
    IBOutlet id boardSource;
    IBOutlet id boardView;
	IBOutlet id threadArrayController;
    IBOutlet id threadSource;
    IBOutlet id threadView;
	
	int progressStack;
	
	NSMutableDictionary *boardNameCache;
}

+ (SQLiteDB *)sqliteDB;

- (IBAction)openInBathyScaphe:(id)sender;
- (IBAction)deleteThreadInfo:(id)sender;
- (IBAction)showThreadInfo:(id)sender;

@property (retain) id window;
@property (retain) id boardArrayController;
@property (retain) id boardSource;
@property (retain) id boardView;
@property (retain) id threadArrayController;
@property (retain) id threadSource;
@property (retain) id threadView;
@property int progressStack;
@property (retain) NSMutableDictionary *boardNameCache;
@end

@interface BSDBDateTransformer : NSValueTransformer
@end
@interface BSDBNumberTransformer : NSValueTransformer
@end
