//
//  BSIPEReplacer.m
//  BSInlinePreviewer
//
//  Created by 堀 昌樹 on 12/05/18.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "BSIPEReplacer.h"


@interface BSInlinePreviewer(Private)
- (NSImage *)downloadImageURL:(NSURL *)imageURL;
- (NSAttributedString *)attachmentAttributedStringWithImage:(NSImage *)image;
@end

static NSString *BSIPEViewkey = @"BSIPEViewkey";
static NSString *BSIPERangeKey = @"BSIPERangeKey";
static NSString *BSIPEImageKey = @"BSIPEImageKey";
static NSString *BSIPEOffsetKey = @"BSIPEOffsetKey";
static NSString *BSIPELinkKey = @"BSIPELinkKey";

@interface BSIPEReplacer ()
// 画像挿入によって引き起こしたNSTextStorageDidProcessEditingNotificationの回数
@property NSUInteger selfNotified;

@end

@implementation BSIPEReplacer
@synthesize textView = _textView;
@synthesize owner = _owner;

@synthesize selfNotified = _selfNotified;


static NSMutableDictionary *instances = nil;
id keyForTextView(NSTextView *view)
{
	return [NSString stringWithFormat:@"%p", view];
}
+ (id)replaserWithTextView:(NSTextView *)tv
{
	if(!instances) {
		instances = [[NSMutableDictionary alloc] init];
	}
	id result = nil;
	@synchronized(self) {
		result = [instances objectForKey:keyForTextView(tv)];
		[result retain];
	}
	if(result) return [result autorelease];
	
	result = [[[self alloc] init] autorelease];
	@synchronized(self) {
		[instances setObject:result forKey:keyForTextView(tv)];
	}
	return result;
}

- (void)setTextView:(NSTextView *)textView
{
	NSNotificationCenter *nc = [NSNotificationCenter defaultCenter];
	[nc removeObserver:self];
	
	@synchronized(self) {
		[_textView release];
		_textView = [textView retain];
	}
	if(textView) {
		[nc addObserver:self
			   selector:@selector(textDidChange:)
				   name:NSTextStorageDidProcessEditingNotification
				 object:[_textView textStorage]];
		[nc addObserver:self
			   selector:@selector(windowWillClose:)
				   name:NSWindowWillCloseNotification
				 object:[_textView window]];
	}
	[self textDidChange:nil];
}
- (NSTextView *)textView
{
	id result = nil;
	@synchronized(self) {
		result = [_textView retain];
	}
	return [result autorelease];
}
- (id)init
{
	self = [super init];
	if(self) {
		lock = [[NSLock alloc] init];
	}
	return self;
}
- (void)dealloc
{
	[_textView release];
	[lock release];
	
	[super dealloc];
}

- (void)notyfySelf
{
	@synchronized(self) {
		self.selfNotified++;
	}
}
- (void)processNotify
{
	@synchronized(self) {
		self.selfNotified--;
	}
}

NSRange fixRange(NSRange range, NSTextStorage *ts)
{
	NSRange fixedRange = {0,0};
	NSRange searchRange = NSMakeRange(MAX(0, range.location - 20), range.length + 20);
	searchRange = NSIntersectionRange(searchRange, NSMakeRange(0, [ts length]));
	[ts attribute:NSLinkAttributeName atIndex:range.location longestEffectiveRange:&fixedRange inRange:searchRange];
	return fixedRange;
}
- (void)insertImage:(NSDictionary *)attr
{
	NSTextView *tv = [attr objectForKey:BSIPEViewkey];
	NSRange range = NSRangeFromString([attr objectForKey:BSIPERangeKey]);
	id newInsertion = [attr objectForKey:BSIPEImageKey];
	NSUInteger offset = [[attr objectForKey:BSIPEOffsetKey] unsignedIntegerValue];
	range.location += offset;
	
	NSTextStorage *ts = [tv textStorage];
	range = fixRange(range, ts);
	[ts beginEditing];
	{
		[ts addAttribute:BSInlinePreviewerPreviewed
				   value:[NSNumber numberWithBool:YES]
				   range:range];
		
		[ts insertAttributedString:newInsertion atIndex:range.location];
		[self notyfySelf];
	}
	[ts endEditing];
}
- (void)textDidChange:(NSNotification *)no
{
	NSUInteger length = [[self.textView textStorage] length];
	// スレッド変更チェック
	if(length == 0) {
		self.selfNotified = 0;
		return;
	}
	if(self.selfNotified > 0) {
		[self processNotify];
		return;
	}
	
	NSTextStorage *ts = [[self.textView textStorage] copy];
	dispatch_async(dispatch_get_global_queue(0,0), ^{
		
		[lock lock];
		
		NSMutableArray *links = [NSMutableArray array];
		
		[ts enumerateAttribute:NSLinkAttributeName
					   inRange:NSMakeRange(0, [ts length])
					   options:NSAttributedStringEnumerationLongestEffectiveRangeNotRequired
					usingBlock:^(id value, NSRange range, BOOL *stop) {
						NSURL *targetURL = nil;
						if([value isKindOfClass:[NSString class]]) {
							targetURL = [NSURL URLWithString:value];
						}
						if([value isKindOfClass:[NSURL class]]) {
							targetURL = value;
						}
						if(!targetURL) return;
						if([self.owner validateLink:targetURL]) {
							[links addObject:[NSDictionary dictionaryWithObjectsAndKeys:targetURL, BSIPELinkKey,
											  NSStringFromRange(range), BSIPERangeKey, nil]];
						}
					}];
		
		__block NSUInteger offset = 0;
		NSUInteger count = [links count];
		dispatch_apply(count, dispatch_get_global_queue(0,0), ^(size_t index){
			if(!self.textView) return;
			
			id dict = [links objectAtIndex:index];
			NSRange range = NSRangeFromString([dict objectForKey:BSIPERangeKey]);
			if([ts attribute:BSInlinePreviewerPreviewed atIndex:range.location longestEffectiveRange:NULL inRange:range]) {
				return;
			}
			// download image.
			NSImage *image = [self.owner downloadImageURL:[dict objectForKey:BSIPELinkKey]];
			if(!image) return;
			
			id newInsertion = [self.owner attachmentAttributedStringWithImage:image];
			
			
			NSDictionary *attr = [[NSDictionary alloc] initWithObjectsAndKeys:
								  newInsertion, BSIPEImageKey,
								  [dict objectForKey:BSIPERangeKey], BSIPERangeKey,
								  self.textView, BSIPEViewkey,
								  [NSNumber numberWithUnsignedInteger:offset], BSIPEOffsetKey,
								  nil];
			[self performSelectorOnMainThread:@selector(insertImage:) withObject:attr waitUntilDone:NO];
			offset += [newInsertion length];
			[attr release];
		});
		[ts release];
		//		NSLog(@"ts \n%@", ts);
		
		[lock unlock];
	});
}

- (void)windowWillClose:(NSNotification *)notification
{
	[[self retain] autorelease];
	[instances removeObjectForKey:keyForTextView(_textView)];
	self.textView = nil;
}
@end
