//
//  BSIThumbnailSizeView.m
//  BSInlinePreviewer
//
//  Created by 堀 昌樹 on 12/07/22.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "BSIThumbnailSizeView.h"

@implementation BSIThumbnailSizeView
@synthesize imageSize = _imageSize;

- (NSImage *)notFoundImage
{
	NSBundle *myBundle = [NSBundle bundleForClass:[self class]];
	NSString *path = [myBundle pathForImageResource:@"notFound"];
	
	if(!path) return nil;
	
	return [[[NSImage alloc] initWithContentsOfFile:path] autorelease];
}
- (id)initWithFrame:(NSRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
		cell = [[NSImageCell alloc] initImageCell:[self notFoundImage]];
		[cell setImageScaling:NSImageScaleProportionallyUpOrDown];
		[cell setImageAlignment:NSImageAlignCenter];
		[cell setImageFrameStyle:NSImageFramePhoto];
		
		self.imageSize = NSMakeSize(200, 200);
    }
	
    return self;
}

- (void)drawRect:(NSRect)dirtyRect
{
	NSRect frame = [self frame];
	
	NSRect imageRect;
	imageRect.size = _imageSize;
	imageRect.origin.x = (frame.size.width - _imageSize.width) * 0.5;
	imageRect.origin.y = (frame.size.height - _imageSize.height) * 0.5;
//	[cell drawWithFrame:imageRect inView:self];
	[cell drawInteriorWithFrame:imageRect inView:self];
	
	frame.origin = NSZeroPoint;
	[[NSColor controlShadowColor] set];
	NSBezierPath *path = [NSBezierPath bezierPathWithRect:frame];
	[path stroke];
}

- (void)magnifyWithEvent:(NSEvent *)event
{
	CGFloat scale = [event magnification] + 1.0;
	NSSize newSize = self.imageSize;
	newSize.height *= scale;
	newSize.width *= scale;
	if(newSize.height < 10 || newSize.width < 10) return;
	
	self.imageSize = newSize;
	[self setNeedsDisplay:YES];
	
}

- (void)setImageSize:(NSSize)imageSize
{
	if(NSEqualSizes(_imageSize, imageSize)) return;
	_imageSize = imageSize;
}
@end
