//
//  HMValueTransformer.m
//  testAVFoundation
//
//  Created by 堀 昌樹 on 12/06/09.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "HMValueTransformer.h"

#import <AVFoundation/AVFoundation.h>


@implementation HMCMTimeTransformer

+ (Class)transformedValueClass
{
	return [NSNumber class];
}
+ (BOOL)allowsReverseTransformation
{
	return NO;
}

- (id)transformedValue:(id)value
{
	if(!value) return nil;
	
	CMTime time = [value CMTimeValue];
	
	Float64 seconds = CMTimeGetSeconds(time);
	return [NSNumber numberWithDouble:seconds];
}
@end

@implementation HMSecondsDateTransformer
+ (Class)transformedValueClass
{
	return [NSDate class];
}
+ (BOOL)allowsReverseTransformation
{
	return NO;
}
- (id)transformedValue:(id)value
{
	if(!value) return nil;
	
	NSTimeInterval seconds = [value doubleValue];
	seconds -= [[NSTimeZone systemTimeZone] secondsFromGMT];
	
	return [NSDate dateWithTimeIntervalSince1970:seconds];
}
@end

@implementation HMCMTimeDateTransformer
+ (Class)transformedValueClass
{
	return [NSDate class];
}
+ (BOOL)allowsReverseTransformation
{
	return NO;
}
- (id)transformedValue:(id)value
{
	if(!value) return nil;
	
	CMTime time = [value CMTimeValue];
	
	Float64 seconds = CMTimeGetSeconds(time);
	seconds -= [[NSTimeZone systemTimeZone] secondsFromGMT];
	
	return [NSDate dateWithTimeIntervalSince1970:seconds];
}
@end
