#!/bin/sh

. ./_blfsset.sh

APPNAME=IPAfont
VER=00303
TARGET=${APPNAME}$VER
TARGETBALL=$DLD/$TARGET.zip
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh unzip fontconfig
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
ExtractZip

TimeStart

cd $TARGETDIR

paco -p $TARGET "\
install -d -m755 /usr/share/fonts/IPA"

echo Installing...
paco -p+ $TARGET "install -v -m644 *.ttf /usr/share/fonts/IPA" \
	1> $LOG/$TARGET.1_install.log 2>&1 || exit 1

fc-cache -v /usr/share/fonts/IPA \
	1>> $LOG/$TARGET.1_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

