#!/bin/sh

. ./_blfsset.sh

APPNAME=XML-Simple
VER=2.20
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	XML-SAX-Expat XML-SAX XML-LibXML
. $WRK/_checkOptions.sh  Tie-IxHash
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Perling...
perl Makefile.PL \
	1> $LOG/$TARGET.1_perl.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo Testing...
make test \
	1> $LOG/$TARGET.3_test.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.4_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

