#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=lesstif
VER=0.95.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo \ \ Patching...
#patch -Np1 -i $DLD/lesstif-$VER-testsuite_fix-1.patch \
#	1> $LOG/$TARGET.1_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc/X11 \
            --disable-debug \
            --enable-production \
            --with-xdnd \
            --x-includes=$XORG_PREFIX/include \
            --x-libraries=$XORG_PREFIX/lib \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

sed -i "s@libdir)/X11/mwm@sysconfdir)/mwm@" clients/Motif-2.1/mwm/Makefile 

Making
make rootdir=/usr/share/doc/lesstif-$VER \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make rootdir=/usr/share/doc/lesstif-$VER install" \
	1> $LOG/$TARGET.3_install.log 2>&1

ldconfig

paco -p+ $TARGET "ln -v -sf /etc/X11/mwm $XORG_PREFIX/lib/X11"

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

