#!/bin/sh

F=mozconfig

cat > $F << "EOF"
# If you have a multicore machine, firefox will now use all the cores by
# default. Exceptionally, you can reduce the number of cores, e.g. to 1,
# by uncommenting the next line and setting a valid number of CPU cores.
mk_add_options MOZ_MAKE_FLAGS="-j2"

EOF

cat >> $F << "EOF"
# If you have installed DBus-Glib comment out this line:
EOF
if [ "${OPTION_dbusglib}" -eq 1 ]; then
  echo -n \#>>$F
fi
echo ac_add_options --disable-dbus>>$F

cat >> $F << "EOF"

# If you have installed wireless-tools comment out this line:
EOF
if [ "${OPTION_wireless_tools}" -eq 1 ]; then
  echo -n \#>>$F
fi
echo ac_add_options --disable-necko-wifi>>$F

cat >> $F << "EOF"

# If you have installed libnotify comment out this line:
EOF
if [ "${OPTION_libnotify}" -eq 1 ]; then
  echo -n \#>>$F
fi
echo ac_add_options --disable-libnotify>>$F

cat >> $F << "EOF"

# GStreamer is necessary for H.264 video playback in HTML5 Video Player;
# to be enabled, also remember to set "media.gstreamer.enabled" to "true"
# in about:config. If you have installed GStreamer comment out this line:
EOF
if [ "${OPTION_gstreamer0}" -eq 1 ]; then
  echo -n \#>>$F
fi
echo ac_add_options --disable-gstreamer>>$F

cat >> $F << "EOF"

# Uncomment these lines if you have installed optional dependencies:
EOF
if [ "${OPTION_hunspell}" -ne 1 ]; then
  echo -n \#>>$F
fi
echo ac_add_options --enable-system-hunspell>>$F
if [ "${OPTION_startupnotification}" -ne 1 ]; then
  echo -n \#>>$F
fi
echo ac_add_options --enable-startup-notification>>$F

cat >> $F << "EOF"

# Uncomment this line if you compiled Cairo with --enable-tee switch and want
# to use it instead of the bundled one:
EOF
if [ "${OPTION_cairo}" -ne 1 ]; then
  echo -n \#>>$F
fi
echo ac_add_options --enable-system-cairo>>$F

cat >> $F << "EOF"

# If you have not installed Yasm then uncomment this line:
EOF
if [ "${OPTION_yasm}" -ne 1 ]; then
  echo -n \#>>$F
fi
echo ac_add_options --disable-webm>>$F

cat >> $F << "EOF"

# Comment out following options if you have not installed
# recommended dependencies:
EOF
if [ "${OPTION_sqlite}" -ne 1 ]; then
  echo -n \#>>$F
fi
echo ac_add_options --enable-system-sqlite>>$F
if [ "${OPTION_libevent}" -ne 1 ]; then
  echo -n \#>>$F
fi
echo ac_add_options --with-system-libevent>>$F
if [ "${OPTION_libvpx}" -ne 1 ]; then
  echo -n \#>>$F
fi
echo ac_add_options --with-system-libvpx>>$F
if [ "${OPTION_nspr}" -ne 1 ]; then
  echo -n \#>>$F
fi
echo ac_add_options --with-system-nspr>>$F
if [ "${OPTION_nss}" -ne 1 ]; then
  echo -n \#>>$F
fi
echo ac_add_options --with-system-nss>>$F

cat >> $F << "EOF"

# It is recommended not to touch anything below this line
ac_add_options --prefix=/usr
ac_add_options --enable-application=xulrunner

ac_add_options --disable-crashreporter
ac_add_options --disable-installer
ac_add_options --disable-updater
ac_add_options --disable-debug
ac_add_options --disable-tests
ac_add_options --disable-mochitest

ac_add_options --enable-optimize
ac_add_options --enable-strip
ac_add_options --enable-install-strip

ac_add_options --enable-system-ffi
ac_add_options --enable-system-pixman

ac_add_options --enable-shared-js
ac_add_options --with-pthreads

ac_add_options --with-system-bz2
ac_add_options --with-system-jpeg
ac_add_options --with-system-png
ac_add_options --with-system-zlib

mk_add_options MOZ_OBJDIR=@TOPSRCDIR@/xulrunner-build-dir
EOF

