#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=openbox
VER=3.5.2
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	pango 
. $WRK/_checkOptions.sh  \
	imlib2 pyxdg startup-notification
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr                         \
            --libexecdir=/usr/lib/openbox         \
            --sysconfdir=/etc                     \
            --docdir=/usr/share/doc/openbox-$VER  \
            --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

