#!/bin/sh

. ./_blfsset.sh

APPNAME=alsa-lib
VER=1.0.27.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  doxygen python-2
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#Patching
#patch -Np1 -i $DLD//alsa-lib-$VER-upstream_fixes-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1

Configuring
./configure \
	1> $LOG/$TARGET.1_conf.log 2>&1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

