#!/bin/sh

. ./_blfsset.sh

APPNAME=aspell
VER=0.60.6.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

TARGET_dict=aspell6-en
TARGETBALL_dict=${TARGET_dict}-7.1-0.tar.bz2
TARGETDIR_dict=${TARGET_dict}-7.1-0

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/aspell-$VER/aspell{,-dev}.html 

echo Copying...
paco -p+ $TARGET "\
install -v -m644 manual/aspell.html/* \
    /usr/share/doc/aspell-$VER/aspell.html" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 manual/aspell-dev.html/* \
    /usr/share/doc/aspell-$VER/aspell-dev.html" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cd ..

echo Extracting dict...
tar xf $DLD/$TARGETBALL_dict || (echo Tarball not found && exit 1)

cd $TARGETDIR_dict

Configuring
./configure \
	1> $LOG/$TARGET.4_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.5_make.log 2>&1 || exit 1

Installing
paco -p+ $TARGET "\
make install" \
	1> $LOG/$TARGET.6_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

