#!/bin/sh

. ./_blfsset.sh

APPNAME=clucene
VER=2.3.3.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-core-$VER.tar.gz
TARGETDIR=$APPNAME-core-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	cmake
. $WRK/_checkOptions.sh  \
	boost
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/clucene-$VER-contribs_lib-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

echo Unofficial sed...
sed -i '/^Lib/ s|-lclucene-core|& -lclucene-shared|' \
	src/core/libclucene-core.pc.cmake

mkdir build
cd build

echo CMaking...
cmake -DCMAKE_INSTALL_PREFIX=/usr \
      -DBUILD_CONTRIBS_LIB=ON .. \
	1> $LOG/$TARGET.1_cmake.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PacoingDone

