#!/bin/sh

. ./_blfsset.sh

APPNAME=cracklib
VER=2.9.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  python-2
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --with-default-dict=/lib/cracklib/pw_dict \
	    --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/lib/libcrack.so.* /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1
paco -p+ $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libcrack.so) /usr/lib/libcrack.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1

paco -p+ $TARGET "\
install -v -m644 -D $DLD/cracklib-words-20080507.gz \
    /usr/share/dict/cracklib-words.gz" \
	1>> $LOG/$TARGET.3_install.log 2>&1

paco -p+ $TARGET "\
gunzip -v /usr/share/dict/cracklib-words.gz" \
	1>> $LOG/$TARGET.3_install.log 2>&1
paco -p+ $TARGET 'ln -v -s cracklib-words /usr/share/dict/words' \
	1>> $LOG/$TARGET.3_install.log 2>&1

echo $(hostname) >>/usr/share/dict/cracklib-extra-words
paco -p+ $TARGET "cp $DLD/japanese /usr/share/dict" \
	1>> $LOG/$TARGET.3_install.log 2>&1
paco -p+ $TARGET 'install -v -m755 -d /lib/cracklib' \
	1>> $LOG/$TARGET.3_install.log 2>&1
paco -p+ $TARGET 'create-cracklib-dict /usr/share/dict/cracklib-words \
                     /usr/share/dict/cracklib-extra-words \
                     /usr/share/dict/japanese' \
	1>> $LOG/$TARGET.3_install.log 2>&1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

