#!/bin/sh

. ./_blfsset.sh

APPNAME=dbus
VER=1.8.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	expat
. $WRK/_checkOptions.sh  \
	Xorg-lib-libX11 \
        dbus-glib python-2 doxygen
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

groupadd -fg 18 messagebus &&
useradd -c "D-BUS Message Daemon User" -d /var/run/dbus \
        -u 18 -g messagebus -s /bin/false messagebus || [ $? == 9 ]

Configuring
./configure --prefix=/usr                  \
            --sysconfdir=/etc              \
            --localstatedir=/var           \
            --with-console-auth-dir=/run/console/ \
            --without-systemdsystemunitdir \
            --disable-systemd              \
            --disable-static               \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "mv -v /usr/share/doc/dbus \
    /usr/share/doc/dbus-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
dbus-uuidgen --ensure" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

