#!/bin/sh

. ./_blfsset.sh
. ./Xorg/_xorgset.sh

APPNAME=DirectFB
VER=1.7.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	libjpeg-turbo LibVNCServer tslib sysfsutils
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
#LDFLAGS='-L/usr/X11/lib' ./configure --prefix=/usr \
#	--enable-zlib \
sed -i "s@/usr/X11R6@${XORG_PREFIX}@g" $(grep -lr /usr/X11R6 *)
./configure --prefix=/usr --disable-mmx --disable-sse \
	--enable-zlib \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

