#!/bin/sh

. ./_blfsset.sh

APPNAME=distcache
VER=1.5.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET
. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

ENABLESSL=
paco -f openssl 1>/dev/null 2>&1 && echo \ \ found openssl... && ENABLESSL="--enable-ssl --with-ssl=/usr/bin "

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo \ \ Patching unofficial...
patch -Np1 -i $WRK/patch/$TARGET.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
	$ENABLESSL \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

