#!/bin/sh

. ./_blfsset.sh

APPNAME=expect
VER=5.45
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME$VER.tar.gz
TARGETDIR=$APPNAME$VER

echo $TARGET

. $WRK/_checkRequired.sh tcl
. $WRK/_checkOptions.sh  tk
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --with-tcl=/usr/lib \
            --with-tclinclude=/usr/include \
            --enable-shared \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -svf expect5.45/libexpect5.45.so /usr/lib" 

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

