#!/bin/sh

. ./_blfsset.sh

APPNAME=ffmpeg
VER=2.1.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	faac freetype lame openjpeg pulseaudio speex \
	libtheora libvorbis libvpx xvid openssl \
	sdl Xorg-lib-libX11 yasm \
	fontconfig frei0r gnutls libaacplus libass \
	libbluray libcaca libcdio libdc1394 fdk-aac \
	flite gsm libiec61883 libilbc libmodplug \
	libnut opencv opus rtmpdump schroedinger \
	twolame video4linux vo-aacenc vo-amrwbenc \
	x264 libxavs openal texi2html
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#Patching
#patch -Np1 -i $DLD/ffmpeg-$VER-freetype-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
sed -i 's/-lflite"/-lflite -lasound"/' configure
./configure --prefix=/usr        \
            --enable-gpl         \
            --enable-version3    \
            --enable-nonfree     \
            --disable-static     \
            --enable-shared      \
$([ ${OPTION_XorgliblibX11} -eq "1" ] && echo --enable-x11grab) \
$([ ${OPTION_faac} -eq "1" ]          && echo --enable-libfaac) \
            --enable-libfreetype \
$([ ${OPTION_lame} -eq 1 ] && echo --enable-libmp3lame) \
$([ ${OPTION_openjpeg} -eq 1 ] && echo --enable-libopenjpeg) \
$([ ${OPTION_pulseaudio} -eq "1" ]    && echo --enable-libpulse) \
$([ ${OPTION_speex} -eq "1" ]         && echo --enable-libspeex) \
$([ ${OPTION_libtheora} -eq "1" ]     && echo --enable-libtheora) \
$([ ${OPTION_libvorbis} -eq "1" ]     && echo --enable-libvorbis) \
$([ ${OPTION_libvpx} -eq "1" ]        && echo --enable-libvpx) \
$([ ${OPTION_xvid} -eq "1" ]          && echo --enable-libxvid) \
            --enable-openssl     \
$([ ${OPTION_libaacplus} -eq "1" ]      && echo --enable-libaacplus) \
$([ ${OPTION_libass} -eq "1" ]          && echo --enable-libass) \
$([ ${OPTION_fdkaac} -eq "1" ]          && echo --enable-libfdk-aac) \
$([ ${OPTION_libbluray} -eq "1" ]       && echo --enable-libbluray) \
$([ ${OPTION_x264} -eq "1" ]       && echo --enable-libx264) \
            --disable-debug      \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

#--enable-libcdioをつけるとビルドできないため、はずす
#$([ ${OPTION_libcdio} -eq "1" ]         && echo --enable-libcdio) \

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1
gcc tools/qt-faststart.c -o tools/qt-faststart \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m755    tools/qt-faststart /usr/bin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m755 -d /usr/share/doc/ffmpeg" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m644    doc/*.txt \
                    /usr/share/doc/ffmpeg" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

