#!/bin/sh

. ./_blfsset.sh

APPNAME=fontconfig
VER=2.11.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh freetype
. $WRK/_checkOptions.sh  docbook-utils
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --localstatedir=/var \
            --docdir=/usr/share/doc/fontconfig-$VER \
            --disable-docs \
            --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1

install -v -m755 \
    -d /usr/share/{man/man{3,5},doc/fontconfig-$VER/fontconfig-devel} \
	1>> $LOG/$TARGET.3_install.log 2>&1

paco -p+ $TARGET "\
install -v -m644 fc-*/*.1          /usr/share/man/man1" \
	1>> $LOG/$TARGET.3_install.log 2>&1

paco -p+ $TARGET "\
install -v -m644 doc/*.3           /usr/share/man/man3" \
	1>> $LOG/$TARGET.3_install.log 2>&1

paco -p+ $TARGET "\
install -v -m644 doc/fonts-conf.5  /usr/share/man/man5" \
	1>> $LOG/$TARGET.3_install.log 2>&1

paco -p+ $TARGET "\
install -v -m644 doc/fontconfig-devel/* \
    /usr/share/doc/fontconfig-$VER/fontconfig-devel" \
	1>> $LOG/$TARGET.3_install.log 2>&1

paco -p+ $TARGET "\
install -v -m644 doc/*.{pdf,sgml,txt,html} \
    /usr/share/doc/fontconfig-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

