#!/bin/sh

. ./_blfsset.sh

APPNAME=gamin
VER=0.1.10
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh glib-2
. $WRK/_checkOptions.sh  python-2
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo \ \ Patching unofficial...
#patch -Np1 -i $WRK/patch/gamin-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i 's/G_CONST_RETURN/const/' server/gam_{node,subscription}.{c,h} 

Configuring
./configure --prefix=/usr --libexecdir=/usr/sbin --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/gamin-$VER \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 doc/*.{html,fig,gif,txt} /usr/share/doc/gamin-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

