#!/bin/sh

. ./_blfsset.sh

APPNAME=geoclue
VER=0.12.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	dbus-glib gconf libxslt
. $WRK/_checkOptions.sh  \
	libsoup NetworkManager gpsd gtk+-2 oFono
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/geoclue-$VER-gpsd_fix-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i "s@ -Werror@@" configure
sed -i "s@libnm_glib@libnm-glib@g" configure
sed -i "s@geoclue/libgeoclue.la@& -lgthread-2.0@g" \
       providers/skyhook/Makefile.in

Configuring
./configure --prefix=/usr --libexecdir=/usr/lib/geoclue \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

