#!/bin/sh

. ./_blfsset.sh

APPNAME=gstreamer
APPVER=1
VER=1.2.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	glib-2
. $WRK/_checkOptions.sh  \
	gobject-introspection gsl gtk-doc valgrind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --libexecdir=/usr/lib \
            --with-package-name="GStreamer $VER BLFS" \
            --with-package-origin="http://www.linuxfromscratch.org/blfs/view/svn/" \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

