#!/bin/sh

. ./_blfsset.sh

APPNAME=jasper
VER=1.900.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.zip
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh unzip
. $WRK/_checkOptions.sh 
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
ExtractZip

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/jasper-$VER-security_fixes-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr --enable-shared --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/jasper-1.900.1
paco -p+ $TARGET "install -v -m644 doc/*.pdf /usr/share/doc/jasper-1.900.1" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

