#!/bin/sh

. ../_blfsset.sh
. ./_kdeset.sh

VER=0.7.1
TARGET=phonon-backend-vlc-$VER
TARGETBALL=$KDEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	phonon vlc
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

#if [ ${OPTION_LinuxPAM} -eq "1" ]; then
#  export WITHPAM=""
#else
#  export WITHPAM="--without-pam "
#fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Cmaking...
mkdir build
cd build
cmake -DCMAKE_INSTALL_PREFIX=$KDE_PREFIX \
      -DCMAKE_BUILD_TYPE=Release         \
      .. \
	1> $LOG/$TARGET.1_cmake.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PacoingDone

