#!/bin/sh

. ../_blfsset.sh
. ./_kdeset.sh

APPNAME=polkit-qt
VER=0.103.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-1-$VER.tar.bz2
TARGETDIR=$APPNAME-1-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	automoc4 polkit
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

mkdir build
cd build

echo Cmaking...
CMAKE_PREFIX_PATH=$QTDIR \
      cmake -DCMAKE_INSTALL_PREFIX=$KDE_PREFIX .. \
	1> $LOG/$TARGET.1_cmake.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PacoingDone

