#!/bin/sh

. ./_blfsset.sh

APPNAME=libatomic_ops
VER=7.2e
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$APPNAME-7.2

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i 's#AM_CONFIG_HEADER#AC_CONFIG_HEADERS#' configure.ac
sed -i 's#AC_PROG_RANLIB#AC_LIBTOOL_DLOPEN\nAC_PROG_LIBTOOL#' configure.ac
sed -i 's#b_L#b_LTL#;s#\.a#.la#g;s#_a_#_la_#' src/Makefile.am
sed -i 's#\.a#.so#g;s#\.\./src/#../src/.libs/#g' tests/Makefile.am
sed -i 's#pkgdata#doc#' doc/Makefile.am

echo Autoreconfing...
autoreconf -fi \
	1> $LOG/$TARGET.1_auto.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
            --docdir=/usr/share/doc/libatomic_ops-$VER \
            --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

