#!/bin/sh

. ./_blfsset.sh

APPNAME=libgdiplus
VER=2.10.9
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	Xorg-lib-libX11 \
        glib-2 libpng tiff libungif
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC

RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo \ \ Patching unofficial...
patch -Np0 -i $WRK/patch/libgdiplus-$VER.patch \
	1> $LOG/$TARGET.0.patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

