#!/bin/sh

. ./_blfsset.sh

APPNAME=libmpeg2
VER=0.5.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i 's/static const/static/' libmpeg2/idct_mmx.c

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m755 -d /usr/share/doc/mpeg2dec-0.5.1" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m644 README doc/libmpeg2.txt \
                    /usr/share/doc/mpeg2dec-0.5.1" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

