#!/bin/sh

. ./_blfsset.sh

APPNAME=lsb-release
VER=1.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Building...
./help2man -N --include ./lsb_release.examples \
              --alt_version_key=program_version ./lsb_release > lsb_release.1 \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "\
install -v -m 644 lsb_release.1 /usr/share/man/man1/lsb_release.1" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m 755 lsb_release /usr/bin/lsb_release" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

