#!/bin/sh

. ../_blfsset.sh
. ./_lxdeset.sh

APPNAME=lxsession-edit
VER=0.2.0
TARGET=$APPNAME-$VER
TARGETBALL=$LXDEDLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh gtk+
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo \ \ Patching unofficial...
#patch -Np1 -i $WRK/patch/lxsession-edit-0.1.1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

#echo \ \ Autogen
#./autogen.sh \
#	1> $LOG/$TARGET.1_auto.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

