#!/bin/sh

. ./_blfsset.sh

APPNAME=ntp
VER=4.2.6p5
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	libcap2
. $WRK/_checkOptions.sh  \
	openssl libedit
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

groupadd -g 87 ntp &&
useradd -c "Network Time Protocol" -d /var/lib/ntp -u 87 \
        -g ntp -s /bin/false ntp

cd $TARGETDIR

Configuring
./configure --prefix=/usr     \
	--sysconfdir=/etc     \
        --enable-linuxcaps    \
	--with-binsubdir=sbin \
        --with-lineeditlibs=readline \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -o ntp -g ntp -d /var/lib/ntp" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/ntp-$VER
paco -p+ $TARGET "\
cp -v -R html/* /usr/share/doc/ntp-$VER/" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cat > /etc/ntp.conf << "EOF"
# Asia
server 0.asia.pool.ntp.org

# Australia
server 0.oceania.pool.ntp.org

# Europe
server 0.europe.pool.ntp.org

# North America
server 0.north-america.pool.ntp.org

# South America
server 2.south-america.pool.ntp.org

driftfile /var/lib/ntp/ntp.drift
pidfile   /var/run/ntpd.pid
EOF
paco -p+ $TARGET "\
touch /etc/ntp.conf" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

