#!/bin/sh

. ./_blfsset.sh

APPNAME=OpenJDK
VER=1.7.0.51
VER2=2.4.4
TARGET=$APPNAME-$VER
if test $(uname -m) = i686; then
TARGETDIR=$APPNAME-$VER-i686-bin
TARGETBALL=$APPNAME-$VER-i686-bin.tar.xz
else
TARGETDIR=$APPNAME-$VER-x86_64-bin
TARGETBALL=$APPNAME-$VER-x86_64-bin.tar.xz
fi

echo $TARGET \($(uname -m)\)

cd $SRC

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

install -vdm755 /opt/OpenJDK-$VER-bin

paco -p+ $TARGET "mv -v * /opt/OpenJDK-$VER-bin" \
	1> $LOG/$TARGET.1_move.log 2>&1 || exit 1

chown -v -R root:root /opt/OpenJDK-$VER-bin \
	1> $LOG/$TARGET.2_chown.log 2>&1 || exit 1

export PATH_HOLD="${PATH}"
export JAVA_HOME="/opt/OpenJDK-$VER-bin"
export CLASSPATH=".:/usr/share/java"
export PATH="${PATH}:${JAVA_HOME}/bin"

pushd /opt

paco -p+ $TARGET "ln -v -nsf OpenJDK-$VER-bin /opt/jdk"

cat > /etc/profile.d/openjdk.sh << "EOF"
# Begin /etc/profile.d/openjdk.sh

# Set JAVA_HOME directory
JAVA_HOME=/opt/jdk

# Adjust PATH
pathappend ${JAVA_HOME}/bin PATH

# Auto Java CLASSPATH
# Copy jar files to, or create symlinks in this directory
AUTO_CLASSPATH_DIR=/usr/share/java
pathprepend . CLASSPATH
for dir in `find ${AUTO_CLASSPATH_DIR} -type d 2>/dev/null`; do
    pathappend $dir CLASSPATH
done
for jar in `find ${AUTO_CLASSPATH_DIR} -name "*.jar" 2>/dev/null`; do
    pathappend $jar CLASSPATH
done

export JAVA_HOME CLASSPATH
unset AUTO_CLASSPATH_DIR
unset dir
unset jar

# End /etc/profile.d/openjdk.sh
EOF

popd

paco -p+ $TARGET "touch /etc/profile.d/openjdk.sh"

cat >> /etc/man_db.conf << "EOF"
MANDATORY_MANPATH     /opt/jdk/man
MANPATH_MAP           /opt/jdk/bin     /opt/jdk/man
MANDB_MAP             /opt/jdk/man     /var/cache/man/jdk
EOF

paco -p+ $TARGET "touch /etc/man_db.conf "

paco -p+ $TARGET "\
mandb -c /opt/jdk/man"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

