#!/bin/sh

. ./_blfsset.sh

APPNAME=polkit
VER=0.112
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	glib-2 intltool js
. $WRK/_checkOptions.sh  \
	docbook-xml docbook-xsl \
        gobject-introspection gtk-doc libxslt Linux-PAM
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_LinuxPAM} -eq "1" ]; then
  export WITHAUTHFW="--with-authfw=pam "
else
  export WITHAUTHFW="--with-authfw=shadow "
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

groupadd -fg 27 polkitd &&
useradd -c "PolicyKit Daemon Owner" -d /etc/polkit-1 -u 27 \
        -g polkitd -s /bin/false polkitd

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --localstatedir=/var \
            $WITHAUTHFW \
            --disable-static \
            --libexecdir=/usr/lib/polkit-1 \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cat > /etc/pam.d/polkit-1 << "EOF"
# Begin /etc/pam.d/polkit-1

auth     include        system-auth
account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/polkit-1
EOF
paco -p+ $TARGET "touch /etc/pam.d/polkit-1"

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

