#!/bin/sh

. ./_blfsset.sh
. ./Xorg/_xorgset.sh

APPNAME=qt
APPVER=4
VER=4.8.5
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/qt-everywhere-opensource-src-$VER.tar.gz
TARGETDIR=qt-everywhere-opensource-src-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	Xorg-lib-libX11
. $WRK/_checkOptions.sh  \
	dbus libjpeg-turbo libmng tiff libpng \
        pkg-config \
	gst-plugins-base-0 pulseaudio glib-2 gtk+-2 openssl \
	cups mysql postgresql unixODBC sqlite
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i -e "/#if/d" -e "/#error/d" -e "/#endif/d" \
     config.tests/unix/libmng/libmng.cpp
sed -i '/CONFIG -/ a\isEmpty(OUTPUT_DIR): OUTPUT_DIR = ../..' \
     src/3rdparty/webkit/Source/WebKit2/DerivedSources.pro

export QTDIR=/opt/qt-$VER

Configuring
./configure -prefix $QTDIR       \
            -sysconfdir /etc/xdg \
            -confirm-license     \
            -opensource          \
            -release             \
            -dbus-linked         \
            -openssl-linked      \
            -system-sqlite       \
            -plugin-sql-sqlite   \
            -no-phonon           \
            -no-phonon-backend   \
            -no-nis              \
            -no-openvg           \
            -nomake demos        \
            -nomake examples     \
            -optimized-qmake     \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -svfn qt-$VER /opt/qt" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cat >> /etc/ld.so.conf << "EOF"
# Begin Qt addition

/opt/qt/lib

# End Qt addition
EOF
ldconfig

cat > /etc/profile.d/qt.sh << "EOF"
# Begin /etc/profile.d/qt.sh

QTDIR=/opt/qt

pathappend /opt/qt/bin           PATH
pathappend /opt/qt/lib/pkgconfig PKG_CONFIG_PATH

export QTDIR

# End /etc/profile.d/qt.sh
EOF
paco -p+ $TARGET "touch /etc/profile.d/qt.sh"

for file in `basename -a -s .prl $QTDIR/lib/libQt*.prl`; do
  sed -i -e '/^QMAKE_PRL_BUILD_DIR/d;s/\(QMAKE_PRL_LIBS =\).*/\1/' \
       $QTDIR/lib/${file}.prl
  perl -pi -e "s, -L$PWD/?\S+,,g" $QTDIR/lib/pkgconfig/${file##lib}.pc
done

unset file

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

