#!/bin/sh

. ./_blfsset.sh

APPNAME=serf
VER=1.3.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	apr-util openssl scons
. $WRK/_checkOptions.sh  \
	krb5
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i "/Append/s:RPATH=libdir,::"   SConstruct
sed -i "/Default/s:lib_static,::"    SConstruct
sed -i "/Alias/s:install_static,::"  SConstruct
sed -i '/get.*_LIBS/s:)):, '\'\''&:' SConstruct

echo Scons...
scons  PREFIX=/usr \
	1> $LOG/$TARGET.1_scons.log 2>&1 || exit 1

#echo Unofficial sed to serf-1.pc
#sed -i "/prefix=/s|/usr/local|/usr|" serf-1.pc

Installing
paco -p $TARGET "\
scons PREFIX=/usr install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

