#!/bin/sh

. ./_blfsset.sh

APPNAME=soprano
VER=2.9.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	cmake qt-4 redland
. $WRK/_checkOptions.sh  \
	clucene dbus libiodbc doxygen sesame2
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/soprano-$VER-dbus-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

mkdir build
cd build

echo CMaking...
cmake -DCMAKE_INSTALL_PREFIX=/usr \
      -DCMAKE_BUILD_TYPE=Release  \
      .. \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -m755 -d /srv/soprano

cat > /etc/sysconfig/soprano <<EOF
# Begin /etc/sysconfig/soprano

SOPRANO_STORAGE="/srv/soprano"
SOPRANO_BACKEND="virtuoso"                       # virtuoso, sesame2, redland
#SOPRANO_OPTIONS="$SOPRANO_OPTIONS --port 4711"  # Default port is 5000

# End /etc/sysconfig/soprano
EOF

paco -p+ $TARGET "\
touch /etc/sysconfig/soprano"

TimeEnd

cd ../..
RemoveSrcDir
PacoingDone

