#!/bin/sh

. ./_blfsset.sh

APPNAME=tidy
VER=20101110
TARGET=tidy-cvs-$VER
TARGETBALL=$DLD/tidy-cvs_$VER.tar.bz2
TARGETDIR=tidy-cvs_$VER

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  dmalloc
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 -D htmldoc/tidy.1 \
                    /usr/share/man/man1/tidy.1" \
	1> $LOG/$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m755 -d /usr/share/doc/$TARGET" \
	1>> $LOG/$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644    htmldoc/*.{html,gif,css} \
                    /usr/share/doc/$TARGET" \
	1>> $LOG/$TARGET.4_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

