#/bin/sh

. ./_blfsset.sh

APPNAME=udev
VER=208
VER2=$VER-2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/systemd-$VER.tar.xz
TARGETDIR=systemd-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	glib-2 gperf gobject-introspection
. $WRK/_checkOptions.sh  \
	acl pciutils usbutils
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

tar -xf $DLD/udev-lfs-${VER2}.tar.bz2

#echo Patching unofficial...
#patch -Np1 -i $WRK/patch/udev-extra-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

#echo \ \ Making...
#make -f udev-lfs-${VER2}/Makefile.lfs \
#	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

#echo Keymap...
#make -f udev-lfs-${VER2}/Makefile.lfs keymap \
#	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1
#paco -p $TARGET "\
#make -f udev-lfs-${VER2}/Makefile.lfs install-keymap" \
#	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo gudev...
make -f udev-lfs-${VER2}/Makefile.lfs gudev \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1
paco -p+ $TARGET "\
make -f udev-lfs-${VER2}/Makefile.lfs install-gudev" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo GObject Files...
make -f udev-lfs-${VER2}/Makefile.lfs gir-data \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1
paco -p+ $TARGET "\
make -f udev-lfs-${VER2}/Makefile.lfs install-gir-data" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

