#!/bin/sh

. ./_blfsset.sh

APPNAME=unixODBC
VER=2.3.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  pth
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
        --sysconfdir=/etc/unixODBC \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

find doc -name "Makefile*" -exec rm {} \; 
chmod 644 doc/{lst,ProgrammerManual/Tutorial}/* 

install -v -m755 -d /usr/share/doc/unixODBC-$VER \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
cp -v -R doc/* /usr/share/doc/unixODBC-$VER" \
	1> $LOG/$TARGET.4_copy.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

