#!/bin/sh

. ./_blfsset.sh

APPNAME=virtuoso
VER=6.1.7
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-opensource-$VER.tar.gz
TARGETDIR=$APPNAME-opensource-$VER

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	libiodbc libxml2 openssl openldap \
        imagemagick python-2
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i "s|virt_iodbc_dir/include|&/iodbc|" configure

Configuring
./configure --prefix=/usr                             \
            --sysconfdir=/etc                         \
            --localstatedir=/var                      \
            --with-iodbc=/usr                         \
            --with-readline                           \
            --without-internal-zlib                   \
            --program-transform-name="s/isql/isql-v/" \
            --disable-all-vads                        \
            --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/virtuoso-$VER
paco -p+ $TARGET "\
ln -s   -v          ../../virtuoso/doc \
                    /usr/share/doc/virtuoso-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

